<?php
/**
 * Copyright Ralf Stadtaus info@stadtaus.com
 */
class UrlExpiration
{
    /**
     * Encryption key
     */
    private $encryptionKey = '';

    /**
     * Expiration time range in seconds
     */
    private $expiresAfter = null;

    /**
     *
     */
    public function __construct($config = array())
    {
        if (isset($config['encryptionKey'])) {
            $this->encryptionKey = $config['encryptionKey'];
        }
        if (isset($config['expiresAfter'])) {
            $this->expiresAfter = $config['expiresAfter'];
        }
    }

    /**
     * Create param
     */
    public function createParameter()
    {
        return $this->encryptString(time());
    }

    /**
     * Test if param is expired
     */
    public function isExpired($param)
    {
        if (is_null($this->expiresAfter)) {
            return false;
        }

        $time = (int) $this->decryptString($param);

        if ((time() - (int) $this->expiresAfter) > $time) {
            return true;
        }
    }

    /**
     * Encrypt string
     */
    private function encryptString($string)
    {   
        $iv = openssl_random_pseudo_bytes(16);
        return base64_encode(openssl_encrypt($string, 'aes-256-ctr', $this->encryptionKey, OPENSSL_RAW_DATA, $iv));
    }

    /**
     * Decrypt string
     */
    private function decryptString($string)
    {
        return openssl_decrypt(base64_decode($string), 'aes-256-ctr', $this->encryptionKey);
    }
}